<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ZoomMember extends Model
{
    use HasFactory;
    protected $guarded = [];

    /**
     * Retrieve the zoom meetings associated with this user.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function zoomMeetings()
    {
        return $this->hasMany(ZoomMeeting::class, 'host_id', 'zoom_user_id');
    }

    /**
     * Define a relationship to get the average meeting duration for the user.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function averageMeetingDuration()
    {
        return round($this->zoomMeetings()->avg('duration'));
    }
}
