<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ZoomMeeting extends Model
{
    use HasFactory;
    protected $guarded = [];

    /**
     * Retrieves the host of the ZoomMember.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function host()
    {
        return $this->hasOne(ZoomMember::class, 'zoom_user_id', 'host_id');
    }
}
