<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ZoomDevice extends Model
{
    use HasFactory;

    protected $guarded = [];

    /**
     * Format last_start_time
     *
     * @param mixed $date
     *
     * @return date
     */
    public function getLastStartTimeAttribute($date)
    {
        return parse_gerneral_datetime($date);
    }

    /**
     * The asset associated with the Zoom device.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function asset()
    {
        return $this->belongsTo('App\Models\Asset');
    }

    /**
     * The location associated with the Zoom device.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function location()
    {
        return $this->belongsTo('App\Models\Location');
    }

    /**
     * Filter the query by the given value on the given field.
     * If the given value is an array, use `whereIn`, otherwise use `where`.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @param  mixed  $value
     * @param  string  $field
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeRelationData($query, $value, $field)
    {
        if ($value) {
            if (is_array($value)) {
                return $query->whereIn($field, $value);
            }
            return $query->where($field, $value);
        }

        return $query;
    }

    /**
     * The Neat device associated with the Zoom device.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function neatDevice()
    {
        return $this->hasOne('App\Models\NeatDevice', 'serial_no', 'serial_no');
    }

    /**
     * The Logitech device associated with the Zoom device.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function logitechDevice()
    {
        return $this->hasOne('App\Models\LogitechDevice', 'serial_no', 'serial_no');
    }

    /**
     * The Dten device associated with the Zoom device.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function dtenDevice()
    {
        return $this->hasOne('App\Models\DtenDevice', 'dten_id', 'serial_no');
    }
}
