<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class VendorCategory extends Model
{
    protected $guarded = [];

    public function vendors()
    {
        return $this->belongsToMany(Vendor::class, 'vendor_category_vendors');
    }

    public function scopeGetFromName($query, $name)
    {
        return $query->where('name', $name);
    }

    /**
     * Get the name attribute in uppercase.
     *
     * @param string $name description
     * @return string
     */
    public function getNameAttribute($name)
    {
        return ucfirst($name);
    }
}
