<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Vendor extends Model
{
    protected $guarded = [];

    public function region()
    {
    	return $this->belongsTo('App\Models\Region');
    }

    public function assetType()
    {
        return $this->belongsTo('App\Models\AssetType');
    }


    /**
     * Relation to software license
     * @return [type]
     */
    public function softwareAssets()
    {
        return $this->hasMany('App\Models\SoftwareLicense\SoftwareLicense');
    }

    public function assets()
    {
        return $this->hasMany('App\Models\Asset');
    }

    public function scopeGetFromName($query, $name)
    {
        return $query->where('name', $name);
    }

    /**
     * Get the name attribute in uppercase.
     *
     * @param string $name description
     * @return string
     */
    public function getNameAttribute($name)
    {
        return ucfirst($name);
    }

    public function vendorCategories()
    {
        return $this->belongsToMany(VendorCategory::class, 'vendor_category_vendors');
    }
}
