<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UserType extends Model
{
    protected $guarded = [];

    public function scopePeople($query)
    {
    	return $query->whereIn('name', ['Employee']);
    }

    public function scopePeoples($query)
    {
        return $query->whereIn('name', ['Employee', 'Administrator']);
    }

    public function scopeAdmin($query)
    {
        return $query->where('is_admin',1)->where('name', '!=', 'Super Admin')->where('name', '!=', 'Super User');
    }

    public function scopeAdminUsers($query)
    {
        return $query->where('is_admin',1)->where('name', '!=', 'Super Admin');
    }

    public function scopeUserRoles($query)
    {
        return $query->where('name', '!=', 'Super Admin')->where('name', '!=', 'Super User')->where('name', '!=', 'Research User');
    }

    public function scopeRoles($query)
    {
        return $query->where('is_admin',1);
    }
    public static  function getusertype()
    { 	
    	// $jsonArray = UserType::get(['id','name']);
   		// $print_arr="{";
     // 	foreach ($jsonArray as $key => $value) {
     //    	 $print_arr=$print_arr."'".$value->id."'".":'".$value->name."',";
     // 	}

     //    $prnt=$print_arr."}";
    	// return '{"0": "G30", "1": "F12/F13", "2": "(5th gen)", "3": "((6th gen))"}';
    
    }
}
