<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UserLoginHistory extends Model
{
    protected $guarded = [];

    /**
     * Retrieves the associated User model.
     *
     * @return \App\User The associated User model.
     */
    public function user()
    {
        return $this->belongsTo('App\User');
    }

    /**
     * Formats the given date string into a specific format.
     *
     * @param string $date The date string to be formatted.
     *
     * @return string|null The formatted date string or null if the input is empty.
     */
    public function getCreatedAtAttribute($date)
    {
        return !empty($date) ? parse_datetime_from_db_datetime($date) : null;
    }

    /**
     * Scope a query to only include users who have a user type other than 'Super Admin'.
     *
     * @param \Illuminate\Database\Eloquent\Builder $query The query builder instance.
     *
     * @return \Illuminate\Database\Eloquent\Builder The modified query builder instance.
     */
    public function scopeNonTeqtivityUsers($query)
    {
        return $query->whereHas('user.userType', function ($query) {
            $query->whereNotIn('name', ['Super Admin']);
        });
    }
}
