<?php

namespace App\Models\SoftwareLicense;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SoftwareLicenseSubscription extends Model
{
    use HasFactory, SoftDeletes;
    protected $guarded = [];
    protected $casts = ['deleted_at' => 'datetime'];

    /**
     * Relation with Software License
     */
    public function licenses()
    {
        return $this->hasMany('App\Models\SoftwareLicense\SoftwareLicense');
    }
}
