<?php

namespace App\Models\SoftwareLicense;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SoftwareLicenseManufacturer extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $guarded = [];
    protected $casts = ['deleted_at' => 'datetime'];

    /**
     * Relation with Software License
     */
    public function licenses()
    {
        return $this->hasMany('App\Models\SoftwareLicense\SoftwareLicense');
    }
}
