<?php

namespace App\Models\SoftwareLicense;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SoftwareLicenseKey extends Model
{
    use HasFactory;
    protected $guarded = [];

    /**
     * Relation with Software Licence Key
     */
    public function license()
    {
        return $this->belongsTo('App\Models\SoftwareLicense\SoftwareLicense','software_license_id','id');
    }

    /**
     * Relation with Software Licence Users
     */
    public function licenseUsers()
    {
        return $this->hasMany('App\Models\SoftwareLicense\SoftwareLicenseUser');
    }
}
