<?php

namespace App\Models\SoftwareLicense;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class SoftwareLicenseHistory extends Model
{

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $guarded = [];

    /**
     * Retrieves the associated User model.
     */
    public function user()
    {
        return $this->belongsTo('App\User');
    }

    public function SoftwareLicense()
    {
        return $this->belongsTo('App\Models\SoftwareLicense\SoftwareLicense');
    }

    public function getCreatedAtAttribute($date)
    {
        return parse_date_from_db_datetime($this->attributes['created_at']);
    }

    /**
     * get create date attribute
     *
     * @return string
     */
    public function getCreatedDateAttribute()
    {
        $date = $this->attributes['created_at'];

        $varDate = Carbon::createFromFormat('Y-m-d H:i:s', $date);

        if ($varDate->isToday()) {
            return " Today at " . $varDate->format('g:i:s A');
        } elseif ($varDate->isYesterday()) {
            return " Yesterday at " . $varDate->format('g:i:s A');
        }

        return $varDate->format('F \ j Y \a\t g:i:s A');
    }
}
