<?php

namespace App\Models\SoftwareLicense;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SoftwareLicense extends Model
{
    use HasFactory;
    use SoftDeletes;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $guarded = [];

    /**
     * Relation with Software Licence Category
     */
    public function category()
    {
        return $this->belongsTo('App\Models\SoftwareLicense\SoftwareLicenseCategory', 'software_license_category_id');
    }

    /**
     * Relation with Software Licence SoftwareLicenseManufacturer
     */
    public function softwareLicenseManufacturer()
    {
        return $this->belongsTo('App\Models\SoftwareLicense\SoftwareLicenseManufacturer', 'software_license_manufacturer_id');
    }

    /**
     * Relation with Software Licence Subscription
     */
    public function subscriptionLength()
    {
        return $this->belongsTo('App\Models\SoftwareLicense\SoftwareLicenseSubscription', 'software_license_subscription_id');
    }

    /**
     * Relation with Software Licence Key
     */
    public function licenseKey()
    {
        return $this->hasMany('App\Models\SoftwareLicense\SoftwareLicenseKey');
    }


    /**
     * Relation with Software Licence User
     */
    public function licenseUser()
    {
        return $this->hasMany('App\Models\SoftwareLicense\SoftwareLicenseUser');
    }

    /**
     * Relation with Vendor
     */
    public function vendor()
    {
        return $this->belongsTo('App\Models\Vendor');
    }

    /**
     * Relation with owner
     */
    public function owner()
    {
        return $this->belongsTo('App\User', 'owner_id');
    }
    /**
     * Relation with Software Licence Documents
     */
    public function document()
    {
        return $this->hasMany('App\Models\SoftwareLicense\SoftwareLicenseDocument', 'software_license_id');
    }

    /**
     * Relation with Software Licence history
     */
    public function history()
    {
        return $this->hasMany('App\Models\SoftwareLicense\SoftwareLicenseHistory');
    }

    /**
     * format Start Date  before display
     */
    public function getStartDateAttribute($date)
    {
        return parse_date_from_db_date($date);
    }

    /**
     * format Renewal Date  before display
     */
    public function getRenewalDateAttribute($date)
    {
        return parse_date_from_db_date($date);
    }

    /**
     * Relation with Payment methos
     */
    public function paymentmethod()
    {
        return $this->belongsTo('App\Models\SoftwareLicense\PaymentMethod', 'payment_method_id');
    }

    /**
     * format auto renewal before display
     */
    public function getAutoRenewalAttribute($value)
    {
        return $value == 'yes' ? 'Yes' : ($value == 'n/a' ? 'N/A' : 'No');
    }

    /**
     * Relation with Software Licence active User
     */
    public function activeLicensedUser()
    {
        return $this->hasMany('App\Models\SoftwareLicense\SoftwareLicenseUser')->where('status', 'active');
    }
}
