<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SiteCode extends Model
{
    protected $guarded = [];

    public function region()
    {
    	return $this->belongsTo('App\Models\Region');
    }

    public function country()
    {
    	return $this->belongsTo('App\Models\Country');
    }

    public function scopeGetFromCode($query, $code)
    {
        return $query->where('code', $code);
    }

    public function locations()
    {
        return $this->hasMany('App\Models\Location');
    }

    public function getCodeAttribute($code)
    {
        return ucfirst($code);
    }
}
