<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SavedSearch extends Model
{
    protected $guarded = [];
    use HasFactory;

    public function scopeUserSavedSearch($query, $userId)
    {
        $query->where('user_id', $userId)->whereNull('view_all');
    }

    public function scopeAdminSavedSearch($query)
    {
        $query->where('view_all', 1);
    }

    public function scopeReportName($query, $reportName)
    {
        $query->where('report_name', $reportName);
    }
}
