<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\User;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class RoleChangeHistory extends Model
{
    use HasFactory;

    protected $guarded = [];

    /**
     * Retrieve the associated User model.
     *
     * @return BelongsTo The associated User model.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the user who made the change.
     *
     * @return BelongsTo
     */
    public function changedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'changed_by_user_id');
    }

    /**
     * A description of the entire PHP function.
     *
     * @return BelongsTo
     */
    public function fromRole(): BelongsTo
    {
        return $this->belongsTo(Role::class, 'from_user_type_id');
    }

    /**
     * Retrieves the role associated with the user type of this model.
     *
     * @return BelongsTo The role associated with the user type.
     */
    public function toRole(): BelongsTo
    {
        return $this->belongsTo(Role::class, 'to_user_type_id');
    }

    /**
     * Retrieves the created at attribute of the model.
     *
     * @param mixed $date The date value to be parsed.
     * @return string|null The parsed date time string, or null if the date is empty or invalid.
     */
    public function getCreatedAtAttribute($date)
    {
        return parse_date_from_db_datetime($date);
    }
}
