<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RevivnPickup extends Model
{
    use HasFactory;
    protected $guarded = [];

    /**
     * Retrieves the related RevivnAsset models.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function revivnAsset()
    {
        return $this->hasMany('App\Models\RevivnAsset');
    }

    public function getScheduledDateAttribute($value)
    {
        return parse_date_from_db_date($this->attributes['scheduled_date']);
    }

    /**
     * Filters the query based on the given value and field.
     *
     * @param \Illuminate\Database\Query\Builder $query The query builder instance.
     * @param mixed $value The value to filter.
     * @param string $field The field to filter on.
     * @return \Illuminate\Database\Query\Builder The modified query builder instance.
     */
    public function scopeRelationData($query, $value, $field)
    {
        if ($value) {
            if (is_array($value)) {

                return $query->whereIn($field, $value);
            }

            return $query->where($field, $value);
        }

        return $query;
    }
}
