<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RevivnAsset extends Model
{
    use HasFactory;

    protected $guarded = [];

    /**
     * asset function.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function asset()
    {
        return $this->belongsTo('App\Models\Asset');
    }

    /**
     * Get the associated RevivnPickup for this instance.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function revivnPickup()
    {
        return $this->belongsTo('App\Models\RevivnPickup');
    }

    /**
     * Retrieves the formatted creation date attribute.
     *
     * @param mixed $value The original attribute value.
     * @return string The formatted creation date in "m/d/Y" format.
     */
    public function getCreatedAtAttribute($date)
    {
        return parse_date_from_db_datetime($this->attributes['created_at']);
    }
}
