<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RetrieverDevice extends Model
{
    use HasFactory;

    protected $guarded = [];

    /**
     * Get the user associated with this model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo('App\User');
    }

    /**
     * Get the asset associated with this model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function asset()
    {
        return $this->belongsTo('App\Models\Asset');
    }

    /**
     * Get the formatted representation of the 'request_charger' attribute.
     *
     * @return string
     */
    public function getRequestChargerAttribute()
    {
        return $this->attributes['request_charger'] == 1 ? 'Yes' : 'No';
    }

    /**
     * Get the formatted representation of the 'created_at' attribute.
     *
     * @param string $date
     * @return string
     */
    public function getCreatedAtAttribute($date)
    {
        return parse_datetime_from_db_datetime($date);
    }

    /**
     * Get the formatted representation of the 'box_shipped_at' attribute.
     *
     * @param string $date
     * @return string
     */
    public function getBoxShippedAtAttribute($date)
    {
        return parse_datetime_from_db_datetime($date);
    }

    /**
     * Get the formatted representation of the 'box_delivered_at' attribute.
     *
     * @param string $date
     * @return string
     */
    public function getBoxDeliveredAtAttribute($date)
    {
        return parse_datetime_from_db_datetime($date);
    }

    /**
     * Get the formatted representation of the 'device_shipped_at' attribute.
     *
     * @param string $date
     * @return string
     */
    public function getDeviceShippedAtAttribute($date)
    {
        return parse_datetime_from_db_datetime($date);
    }

    /**
     * Get the formatted representation of the 'device_delivered_at' attribute.
     *
     * @param string $date
     * @return string
     */
    public function getDeviceDeliveredAtAttribute($date)
    {
        return parse_datetime_from_db_datetime($date);
    }

    /**
     * Get the user email attribute.
     *
     * This method returns an empty string as the user email is considered personal and should not be displayed.
     *
     * @return string
     */
    public function getUserEmailAttribute()
    {
        return ''; // it is a personal email, so will not show anywhere
    }


    /**
     * Get the shipment status attribute.
     *
     * @param datatype $status description
     * @return Some_Return_Value
     */
    public function getShipmentStatusAttribute($status)
    {
        //return $status;
        return config('retriever.shipment_statuses.' . $status);
    }
}
