<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PurgeAssetHistory extends Model
{
    protected $guarded = [];

    public function user()
    {
        return $this->belongsTo('App\User');
    }

    public function getCreatedAtAttribute($date)
    {
        $date = $this->attributes['created_at'];
        return parse_date_from_db_datetime($date);
    }

    public function assetType()
    {
        return $this->belongsTo('App\Models\AssetType');
    }

    public function makeAndModel()
    {
        return $this->belongsTo('App\Models\MakeAndModel');
    }

    public function technicalSpec()
    {
        return $this->belongsTo('App\Models\TechnicalSpecs');
    }
}
