<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class OAuthScope
 *
 * @property int $id
 * @property string $name
 * @property string|null $description
 *
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\ApiClient[] $clients
 * @property-read int|null $clients_count
 *
 * @package App\Models
 */
class OAuthScope extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'oauth_scopes';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'slug',
        'description',
    ];

    /**
     * Define the relationship between OAuthScope and ApiClient models.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function clients()
    {
        return $this->belongsToMany(ApiClient::class, 'oauth_client_scope', 'scope_id', 'client_id');
    }
}
