<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Notification extends Model
{
    public function getAgeAttribute($date)
    {

        $varDate = Carbon::createFromFormat('m/d/Y', parse_date_from_db_datetime($this->attributes['created_at']));

        if (Carbon::now()->diff($varDate)->format('%y') == 0) {
            if (Carbon::now()->diff($varDate)->format('%m') == 0) {
                return Carbon::now()->diff($varDate)->format('%d Days');
            } else {
                return Carbon::now()->diff($varDate)->format('%y Year %m Months');
            }
        }

        return Carbon::now()->diff($varDate)->format('%y Year %m Months %d Days');
    }

    public function getHoursPastAttribute()
    {
        $varDate = Carbon::createFromFormat('Y-m-d H:i:s', $this->attributes['created_at']);

        return Carbon::now()->diffInHours($varDate);
    }

    public function getDataAttribute($value)
    {
        return json_decode($value, true);
    }
}
