<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MobileIron extends Model
{
    protected $guarded = [];
    use HasFactory;
    public function asset()
    {
        return $this->belongsTo('App\Models\Asset');
    }

    public function user()
    {
        return $this->belongsTo('App\User');
    }

    public function setLastCheckinAttribute($date)
    {
        return $this->attributes['last_checkin'] =  format_ms_timestamp_to_db_datetime($date);
    }

    public function getLastCheckinAttribute($date)
    {
        return parse_datetime_from_db_datetime($date);
    }

    public function setEnrolledDateAttribute($date)
    {
        return $this->attributes['enrolled_date'] =  format_ms_timestamp_to_db_datetime($date);
    }

    public function getEnrolledDateAttribute($date)
    {
        return parse_datetime_from_db_datetime($date);
    }

    public function scopeRelationData($query, $value, $field)
    {
        if ($value) {
            if (is_array($value)) {
                return $query->whereIn($field, $value);
            }
            return $query->where($field, $value);
        }
        return $query;
    }

    public function getOwnershipAttribute()
    {
        if (!isset($this->attributes['ownership'])) {
            return '';
        }
        if ($this->attributes['ownership'] === 'COMPANY') {
            return 'Corporate';
        }

        if ($this->attributes['ownership'] == 'S') {
            return 'Shared';
        }

        if ($this->attributes['ownership'] == 'E') {
            return 'Employee Owned';
        }
        return '';
    }

    public function mobileCarrier()
    {
        return $this->belongsTo('App\Models\Carrier', 'carrier_id', 'id');
    }
}
