<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Manufacturer extends Model
{
    protected $guarded = [];

    public function create($name)
    {
    	return $this->firstOrCreate([
            'slug' => str_slug($name, '_')
        ],[
            'name' => $name
        ]);
    }

    public function scopeGetFromName($query, $name)
    {
    	return $query->where('name', $name);
    }

    public function makeAndModel()
    {
        return $this->hasMany('App\Models\MakeAndModel');
    }

    /**
     * Get the name attribute.
     *
     * @param string $name description
     * @return string
     */
    public function getNameAttribute($name)
    {
        return ucfirst($name);
    }

}
