<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LockStatus extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function assets()
    {
        return $this->hasMany('App\Models\Asset');
    }

    public function scopeGetName($query, $name)
    {
        return $query->where('name', $name);
    }

    public function scopeGetId($query, $id)
    {
        return $query->where('id', $id);
    }

    public function scopeGetNameFromSlug($query, $slug)
    {
        return $query->where('slug', $slug);
    }

    public function scopeGetSlugFromName($query, $name)
    {
        return $query->where('name', $name);
    }
}
