<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LocationType extends Model
{
    protected $guarded = [];

    public function locations()
    {
    	return $this->hasMany('App\Models\Location');
    }

    public function scopeWithoutwarehouse($query)
    {
    	return $query->whereIn('location_type_name', ['Warehouse']);
    }

    public function scopeGetFromName($query, $name)
    {
        return $query->where('location_type_name', $name);
    }
}
