<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class KandjiDevices extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function asset()
    {
        return $this->belongsTo('App\Models\Asset');
    }

    public function user()
    {
        return $this->belongsTo('App\User');
    }

    public function scopeRelationData($query, $value, $field)
    {
        if ($value) {
            if (is_array($value)) {
                return $query->whereIn($field, $value);
            }
            return $query->where($field, $value);
        }

        return $query;
    }

    public function mobileCarrier()
    {
        return $this->belongsTo('App\Models\Carrier', 'carrier_id', 'id');
    }

    public function getLastCheckinAttribute($date)
    {
        return parse_datetime_from_db_datetime($date);
    }

    public function getLastEnrollmentAttribute($date)
    {
        return parse_datetime_from_db_datetime($date);
    }
}
