<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JumpCloudDevices extends Model
{
    use HasFactory;

    protected $guarded = [];

    /**
     * Get the asset that owns the JumpCloudDevices
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function asset()
    {
        return $this->belongsTo('App\Models\Asset');
    }

    /**
     * Get the user that owns the JumpCloudDevices
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo('App\User');
    }

    /**
     * Filters the query based on the given value and field.
     *
     * @param \Illuminate\Database\Query\Builder $query The query builder instance.
     * @param mixed $value The value to filter.
     * @param string $field The field to filter on.
     * @return \Illuminate\Database\Query\Builder The modified query builder instance.
     */
    public function scopeRelationData($query, $value, $field)
    {
        if ($value) {
            if (is_array($value)) {
                return $query->whereIn($field, $value);
            }
            return $query->where($field, $value);
        }

        return $query;
    }

    /**
     * Get the formatted representation of the 'last_seen' attribute.
     *
     * @param string $date
     * @return string
     */
    public function getLastSeenAttribute($date)
    {
        return parse_datetime_from_db_datetime($date);
    }
}
