<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IntuneComputer extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function user()
    {
        return $this->belongsTo('App\User');
    }

    public function asset()
    {
        return $this->belongsTo('App\Models\Asset');
    }

    public function getCheckinDateAttribute($date)
    {
        return parse_datetime_from_db_datetime($date);
    }

    public function setCheckinDateAttribute($date)
    {
        return $this->attributes['checkin_date'] = format_date_iso_datetime_to_db_datetime($date);
    }

}
