<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class IntegrationSyncHistory extends Model
{
    protected $guarded = [];
    public function getCreatedAtAttribute()
    {
        return $this->attributes['created_at'] = parse_datetime_from_db_datetime($this->attributes['created_at']);
    }
    /**
     * Retrieve the last synchronized record based on the given sync names.
     *
     * @param mixed $query The query instance.
     * @param array $syncNameList The list of sync names to filter by.
     * @throws Exception if an error occurs during the query execution.
     * @return mixed The last synchronized record.
     */
    public function scopeGetLastSync($query, $syncNameList)
    {
        if (is_array($syncNameList)) {
            return $query->whereIn('sync_name', $syncNameList)->orderBy('created_at', 'desc');
        }

        return $query->where('sync_name', $syncNameList)->orderBy('created_at', 'desc');
    }
}