<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use App\Constants\AssetStatus as AssetStatusConst;

class DepartmentHardwareMapping extends Model
{
    protected $guarded = [];

    public function makeAndModel()
    {
        return $this->belongsTo('App\Models\MakeAndModel', 'make_and_model_id', 'id');
    }

    public function department()
    {
        return $this->hasMany('App\Models\Department', 'id', 'department_id')->orderBy('name');
    }

    public function technicalSpec()
    {
        return $this->belongsTo('App\Models\TechnicalSpecs', 'technical_spec_id', 'id');
    }

    public function inStockAssets()
    {
        $statusIds = AssetStatus::getNameFromSlug(AssetStatusConst::INSTOCKSTATUSES)->pluck('id')->toArray();
        return $this->hasMany('App\Models\Asset', 'technical_spec_id', 'technical_spec_id')->whereIn('asset_status_id', $statusIds);
    }

    public function user()
    {
        return $this->hasMany('App\User', 'department_id', 'department_id');
    }

    public function singleDepartment()
    {
        return $this->belongsTo('App\Models\Department', 'department_id');
    }

    public function newhireUsers()
    {
        return $this->hasMany('App\User', 'department_id', 'department_id')->whereDate('hire_date', '>=', Carbon::now()->format('Y-m-d'));
    }
}
