<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Department extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function user()
    {
        return $this->hasMany('App\User');
    }

    public function hardwarestandard()
    {
        return $this->belongsToMany('App\Models\MakeAndModel', 'department_hardware_mappings');
    }

    /**
     * The function hardwarekits() returns a collection of DepartmentHardwareMapping objects that have
     * a department_id that matches the id of the current Department object
     *
     * @return A collection of DepartmentHardwareMapping objects.
     */
    public function hardwarekits()
    {
        return $this->hasMany('App\Models\DepartmentHardwareMapping', 'department_id', 'id');
    }
}
