<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CycleCountScannedData extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'cycle_count_scanned_datas';

    protected $guarded = [];

    public function scopeUser($query, $userId)
    {
        return $query->where('user_id', $userId);
    }

    public function location()
    {
        return $this->belongsTo('App\Models\Location');
    }
}
