<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CloudAsset extends Model
{
    use HasFactory;

    protected $guarded = [];

    /**
     * Get the created at attribute.
     *
     * @param datatype $createdAt
     * @return date
     */
    public function getCreatedAtAttribute($createdAt)
    {
        return parse_date_from_db_datetime($createdAt);
    }

    /**
     * Get the Launched date attribute.
     *
     * @param datatype $launchedDate
     * @return date
     */
    public function getLaunchedDateAttribute($launchedDate)
    {
        return parse_date_from_db_datetime($launchedDate);
    }
}
