<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Chromebook extends Model
{
    protected $guarded = [];
    use HasFactory;

    public function scopeRelationData($query, $value, $field)
    {
        if ($value) {
            if (is_array($value)) {
                return $query->whereIn($field, $value);
            }
            return $query->where($field, $value);
        }
        return $query;
    }

    public function user()
    {
        return $this->belongsTo('App\User');
    }

    public function asset()
    {
        return $this->belongsTo('App\Models\Asset');
    }

    public function getLastSyncAttribute($date)
    {
        return parse_datetime_from_db_datetime($date);
    }
}
