<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Carrier extends Model
{
    protected $guarded = [];
    use SoftDeletes, HasFactory;
    protected $casts = ['deleted_at' => 'datetime'];

    public function assets()
    {
        return $this->hasMany('App\Models\Asset');
    }

    public function country()
    {
        return $this->belongsTo('App\Models\Country');
    }
}
