<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AssetTypeAttribute extends Model
{
    protected $guarded = [];

    public function assetType()
    {
        return $this->belongsTo('App\Models\AssetType');
    }

    public function assetTypeAttributeValue()
    {
        return $this->hasMany('App\Models\AssetTypeAttributeValue');
    }

    public function scopeGetAttributesByAssetType($query,$asset_type_id)
    {
    	  return $query->where('asset_type_id', $asset_type_id);
    }

    

}
