<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AssetTab extends Model
{
    public function assetTypes()
    {
        return $this->belongsToMany('App\Models\AssetType');
    }

    /**
     * Scope to get asset type IDs for a specific slug.
     *
     * @param \Illuminate\Database\Eloquent\Builder $query
     * @param string $slug
     * @return array
     */
    public function scopeAssetTypeIdsBySlug($query, $slug)
    {
        $assetTab = $query->where('slug', $slug)->first();

        if (!$assetTab) {
            return []; // Return an empty array if no AssetTab is found
        }

        // Get the asset type IDs
        return $assetTab->assetTypes()->pluck('asset_types.id')->toArray();
    }
}
