<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssetHealthTests extends Model
{
    use HasFactory;
    protected $guarded = [];

    protected $fillable = ['category_id'];
    public function assetHealthCategories()
    {
        return $this->belongsToMany('App\Models\AssetHealthCategory');
    }
    public function assetHealthReports()
    {
        return $this->hasMany('App\Models\AssetHealthReports','id');
    }

    /**
     * Scope to retrieve only active tests.
     *
     * @param \Illuminate\Database\Eloquent\Builder $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }
}
