<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssetHealthReports extends Model
{
    protected $guarded = [];
    protected $fillable = ['test_id','category_id','test_count', 'history_id'];

    protected static function boot()
    {
        parent::boot();

        // Hook into the deleting event to delete related records
        static::deleting(function ($history) {
            $history->details()->delete();
        });
    }

    public function assetHealthTest()
    {
    	return $this->belongsTo('App\Models\AssetHealthTests','test_id');
    }

    public function assetHistory()
    {
    	return $this->belongsTo('App\Models\AssetHealthHistory','history_id');
    }

    public function category()
    {
    	return $this->belongsTo('App\Models\AssetHealthCategory','category_id');
    }

    public function details()
    {
        return $this->hasMany(AssetHealthReportDetail::class, 'asset_health_report_id');
    }

    public function ignoredDetails()
    {
        return $this->details()->where('is_ignored',1);
    }
}
