<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssetHealthHistory extends Model
{
    use HasFactory;

    protected $fillable = ['no_of_issues','started_at','ended_at'];

    protected static function boot()
    {
        parent::boot();

        // Hook into the deleting event to delete related records
        static::deleting(function ($history) {
            $history->reports()->delete();
        });
    }

    public function reports()
    {
        return $this->hasMany(AssetHealthReports::class, 'history_id');
    }
}
