<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ApiRequestHistory extends Model
{
    protected $guarded = [];

    public function client()
    {
        return $this->belongsTo(
            'App\Models\ApiClient', 'client_id', 'id'
        );
    }

    public function getCreatedDateAttribute()
    {
        return parse_date_from_db_datetime($this->attributes['created_at']);
    }
    
    public function getApiNameAttribute()
    {
        return config('api.apiRequestNames')[$this->attributes['api_url']] ?? '';
    }
}