<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Http\Traits\Encryptable;

class ApiCredential extends Model
{
    use Encryptable;

    protected $guarded = [];

    protected $encryptable = [
        'password', 'key'
    ];

    protected $dontThrowDecryptException = true;

    /**
     * Adds a slash at end of URL if not present
     * @param mixed $url
     * 
     * @return [type]
     */
    public function setUrlAttribute($url)
    {
        return $this->attributes['url'] =  !empty($url) ? add_slash_at_end($url) : null;
    }
}
