<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ApiClient extends \Laravel\Passport\Client
{
    protected $guarded = [];

    /**
     * Get the user who added the client.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function addedBy()
    {
        return $this->belongsTo(
            'App\User', 'added_by', 'id'
        );
    }

    /**
     * Define the relationship between ApiClient and OAuthScope models for scopes.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function oAuthscopes()
    {
        return $this->belongsToMany(OAuthScope::class, 'oauth_client_scope', 'client_id', 'scope_id');
    }
}
