<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ApiBlockedIp extends Model
{
    protected $guarded = [];


    /**
     * Retrieves the "blocked_at" attribute from the model and parses it into a date.
     *
     * @return mixed The parsed date.
     */
    public function getBlockedAtAttribute()
    {
        return parse_date_from_db_datetime($this->attributes['blocked_at']);
    }

}
