<?php

namespace App\Listeners;

use App\Events\UpdateAssetStatus;
use App\Models\FailedTicketHistory;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Services\Integrations\Tickets\TicketManagementService;
use Illuminate\Support\Facades\Log;

class UpdateTicket implements ShouldQueue
{
    protected $ticketManagementService;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(TicketManagementService $ticketManagementService)
    {
        $this->ticketManagementService = $ticketManagementService;
    }

    /**
     * Handle the event.
     *
     * @param  UpdateAssetStatus  $event
     * @return void
     */
    public function handle(UpdateAssetStatus $event)
    {
        if (!$event->ticketId) {
            return true;
        }

        try {
            $this->ticketManagementService->addComment($event->userId, $event->ticketId, $event->description);
        } catch (\Exception $e) {
            FailedTicketHistory::create([
                'user_id' => $event->userId,
                'ticket_id' => $event->ticketId,
                'description' => $event->description,
                'exceptions' => json_encode($e->getMessage())
            ]);

            Log::channel('single')->info('Ticket failed : ' . $e->getMessage());
        }
    }
}
