<?php

namespace App\Listeners;

use App\Events\UpdateShipmentStatus as EventsUpdateShipmentStatus;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Services\ShipmentTracking\UpdateShipmentStatusService;

class UpdateShipmentStatus  implements ShouldQueue
{
    protected $updateShipmentStatusService;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(EventsUpdateShipmentStatus $event, UpdateShipmentStatusService $updateShipmentStatusService)
    {
        $this->updateShipmentStatusService = $updateShipmentStatusService;
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle($event)
    {
        $this->updateShipmentStatusService->updateShipmentStatus();
    }
}
