<?php

namespace App\Listeners;

use App\Events\UpdateShiShipmentStatus  as EventsUpdateShiShipmentStatus;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Services\ShipmentTracking\ShiShipmentService;

class UpdateShiShipmentStatus implements ShouldQueue
{
    protected $updateShipmentStatusService;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(ShiShipmentService $updateShipmentStatusService)
    {
        $this->updateShipmentStatusService = $updateShipmentStatusService;
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\UpdateShiShipmentStatus as EventsUpdateShiShipmentStatus  $event
     * @return void
     */
    public function handle(EventsUpdateShiShipmentStatus $event)
    {
        $this->updateShipmentStatusService->updateTrackingNumberStatus();
    }
}
