<?php

namespace App\Listeners;

use App\Events\PurchaseIndicator;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Notifications\PurchaseIndicatorSet;
use App\User;
use Illuminate\Support\Facades\Notification;

class SendPurchaseIndicatorNotification implements ShouldQueue
{
    protected $adminEmail;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        $this->adminEmail = config('mail.adminAddress');
    }

    /**
     * Handle the event.
     *
     * @param  PurchaseIndicator  $event
     * @return void
     */
    public function handle(PurchaseIndicator $event)
    {
        $adminUser = User::where('email', $this->adminEmail)->first();

        if ($adminUser) {
            Notification::send($adminUser, new PurchaseIndicatorSet($event->accessory));
        }
    }
}
