<?php

namespace App\Listeners;

use App\Models\UserLoginHistory;
use Illuminate\Support\Facades\Auth;

/**
 * Creates login history when user logs in
 */
class LoginSuccessfulListener
{
    /**
     * Handle the event.
     */
    public function handle(object $event): void
    {
        UserLoginHistory::create([
            'user_id' => Auth::user()->id,
            'ip_address' => getIp(),
        ]);
    }
}
