<?php

namespace App\Listeners;

use App\Events\BulkUpdateTicket as EventBulkUpdateTicket;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Facades\App\Services\Integrations\Tickets\Jira\OAuthWrapper;
use App\Models\ApiCredential;
use App\Models\FailedTicketHistory;
use App\Services\Integrations\Tickets\TicketManagementService;

class BulkUpdateTicket implements ShouldQueue
{
    protected $ticketManagementService;
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(TicketManagementService $ticketManagementService)
    {
        $this->ticketManagementService = $ticketManagementService;
    }

    /**
     * Handle the event.
     *
     * @param  EventBulkUpdateTicket  $event
     * @return void
     */
    public function handle(EventBulkUpdateTicket $event)
    {
        foreach ($event->jiraData as $data) {
            if (!$data['ticketId']) {
                continue;
            }
            try {
                $this->ticketManagementService->addComment($data['userId'], $data['ticketId'], $data['description']);
            } catch (\Exception $e) {
                FailedTicketHistory::create([
                    'user_id' => $data['userId'],
                    'ticket_id' => $data['ticketId'],
                    'description' => $data['description'], // str_replace("\\n", '', $data['description'])
                    'exceptions' => json_encode($e->getMessage())
                ]);
            }
        }
    }
}
